![Argon](https://cdn.jsdelivr.net/gh/solstice23/cdn@master/argon_new_animate.svg)

**简体中文** | [繁體中文](README_tw.md) | [English](README_en.md) | [Russian](README_ru.md)

# Argon-Theme
Argon - 轻盈、简洁、美观的 WordPress 主题

Hexo 版本 : [github.com/solstice23/hexo-theme-argon](https://github.com/solstice23/hexo-theme-argon)

[![GitHub release](https://img.shields.io/github/v/release/solstice23/argon-theme?color=%235e72e4&style=for-the-badge)](https://github.com/solstice23/argon-theme/releases) [![GitHub All Releases](https://img.shields.io/github/downloads/solstice23/argon-theme/total?style=for-the-badge)](https://github.com/solstice23/argon-theme/releases) [![GitHub](https://img.shields.io/github/license/solstice23/argon-theme?color=blue&style=for-the-badge)](https://github.com/solstice23/argon-theme/blob/master/LICENSE) [![Author]( https://img.shields.io/badge/author-solstice23-yellow?style=for-the-badge)](https://github.com/solstice23) [![GitHub stars](https://img.shields.io/github/stars/solstice23/argon-theme?color=ff69b4&style=for-the-badge)](https://github.com/solstice23/argon-theme/stargazers)

[![GitHub last commit](https://img.shields.io/github/last-commit/solstice23/argon-theme?style=flat-square)](https://github.com/solstice23/argon-theme/commits/master) [![GitHub Release Date](https://img.shields.io/github/release-date/solstice23/argon-theme?style=flat-square)](https://github.com/solstice23/argon-theme/releases) ![GitHub code size in bytes](https://img.shields.io/github/languages/code-size/solstice23/argon-theme?style=flat-square)

# 状态

> 重构初步完成，1.x 版本将冻结开发，PR 请提交到 [dev](https://github.com/solstice23/argon-theme/tree/dev) 分支。后续将逐渐重构前端代码。


# 特性

+ **轻盈美观** - 使用 Argon Design System 前端框架，细节精致，轻盈美观
+ **高度可定制化** - 可自定义主题色、布局(双栏/单栏/三栏)、顶栏、侧栏、Banner、背景图、日夜间模式不同背景、背景沉浸、浮动操作按钮等，提供了丰富的自定义选项
+ **夜间模式** - 支持日间、夜间、纯黑三种模式，并可以根据时间自动切换或跟随系统夜间模式
+ **功能繁多** - Tag 和分类统计、作者链接、额外链接、文章字数和预计阅读时间、文章过时信息显示
+ **Pjax** - 支持 Pjax 无刷新加载，提高浏览体验
+ **友情链接** - 支持使用 Wordpress 自带的链接管理器进行友链管理，支持多种友链样式
+ **"说说" 功能** - 随时发表想法，并在专门的 "说说" 页面展示，也支持说说和首页文章穿插
+ **评论功能扩展** - Ajax 评论，评论支持 Markdown、验证码、再次编辑、显示 UA、悄悄话模式、回复时邮件通知、查看编辑记录、无限加载等功能
+ **诸多功能** - 文章目录、阅读进度、Mathjax 或 Katex 公式解析、图片放大预览、Pangu.js 文本格式化、平滑滚动等
+ **丰富的短代码** - 支持通过短代码在文章中插入 TODO、标签、警告、提示、折叠区块、Github 信息卡、时间线、隐藏文本、视频等模块
+ **适配 Gutenberg 编辑器** - 支持使用 Gutenberg 编辑器可视化插入区块
+ **多语言** - 支持中文、英文、俄文等语言
+ **其他** - 自适应、精心优化的文章阅读界面 CSS、可切换衬线/非衬线字体、可自定义 CSS 和 JS、支持使用 CDN 加速静态文件访问、SEO 友好、Banner 打字动画、留言板页面、文章脚注等

# 安装

在 [Release](https://github.com/solstice23/argon-theme/releases) 页面下载 .zip 文件，在 WordPress 后台 "主题" 页面上传并安装。

# 文档

[Argon-Theme 文档 : https://argon-docs.solstice23.top](https://argon-docs.solstice23.top/)

# Demo / 用户墙

[solstice23.top](https://solstice23.top)

[argon-demo.solstice23.top](http://argon-demo.solstice23.top)

前往 [Argon 用户墙](https://argon-showcase.solstice23.top/) 查看更多博客的主题效果。


# 注意

Argon 使用 [GPL V3.0](https://github.com/solstice23/argon-theme/blob/master/LICENSE) 协议开源，请遵守此协议进行二次开发等。

您**必须在页脚保留 Argon 主题的名称及其链接**，否则请不要使用 Argon 主题。

您**可以删除**页脚的作者信息，但是**不能删除** Argon 主题的名称和链接。

# 渲染

![render1](https://cdn.jsdelivr.net/gh/solstice23/cdn@master/argon-render-small-1.jpg)

![render2](https://cdn.jsdelivr.net/gh/solstice23/cdn@master/argon-render-small-2.jpg)

![render3](https://cdn.jsdelivr.net/gh/solstice23/cdn@master/argon-render-small-3.jpg)

![render4](https://cdn.jsdelivr.net/gh/solstice23/cdn@master/argon-render-small-4.jpg)

![render5](https://cdn.jsdelivr.net/gh/solstice23/cdn@master/argon-render-small-5.jpg)

# Telegram 频道
[t.me/argontheme](https://t.me/argontheme)

自动推送更新消息以及其他关于 Argon 的消息

# 更新日志

## 20220319 v1.3.5
+ 支持自定义 CDN 域名
+ 支持读取 Post Views Counter 插件的阅读量数据
+ 修复未审核评论被显示的问题
+ 修复评论分页问题
+ 其他改进与修复

## 20220214 v1.3.4
+ 支持自定义搜索过滤器顺序和默认选中状态
+ 支持添加自定义文章类型的搜索过滤器
+ 修复代码块样式问题
+ 其他改进与修复

## 20220211 v1.3.3
+ 🌈 新增 后台管理界面美化 (在"用户-个人资料-管理界面配色方案" 或 "Argon设置-杂项" 中开启)
+ 新增 CF Worker 更新源，移除 jsdelivr 更新源
+ 支持短代码嵌套
+ 修复多站点下无法编辑主题设置的问题
+ 其他改进与修复

## 20220207 v1.3.2
+ 使评论区第一页填满评论（评论分页方式为无限加载时）
+ 新增 `argon_html_before_wordcount` Filter
+ 修复代码块溢出边界的问题
+ 优化代码块控制栏可见性
+ 修复评论排序问题
+ 其他改进与修复

## 20220205 v1.3.1
+ 📌 新增 评论置顶 功能（需要在选项中开启）
+ 子评论支持显示被回复者昵称
+ 同步 Highlight.js 高亮方案
+ 其他改进与修复

## 20220203 v1.3.0
+ 🎨 新增 气氛色 选项：主题色全局沉浸（类似 Material You）
+ 新增 `argon_comment_extra_info` filter
+ 代码块行号默认不透明
+ 修复首页排除文章和 Tag 选项不生效的 Bug
+ 修复友情链接页面显示错误
+ 修复评论区表单验证问题
+ 修复 session 干扰 REST API 回环问题
+ 修复开启衬线字体后代码块显示问题
+ 修复后台媒体库不能搜索问题
+ 其他改进与修复

## 20220106 v1.2.10
+ 新增通过 Ajax 获取验证码以绕过 CDN 缓存选项
+ 说说预览显示赞数和评论数，优化折叠样式
+ 修复编辑器某些功能的失效
+ 修复评论提醒邮件格式错误
+ 修复 Pangu.js 某些页面不应用
+ 修复搜索结果切换筛选器后页数不重置
+ 修复搜索结果说说预览图片不显示问题
+ 修复 Pjax 右侧栏不刷新的问题
+ 繁体中文翻译修正
+ UI 细节修复与调整
+ 其他修复与改进

## 20211205 v1.2.9
+ 增加搜索过滤器（支持搜索说说）
+ 支持折叠过长说说
+ 修改单篇文章过时信息显示时不覆盖最后编辑时间
+ 其他修复与改进

## 20211121 v1.2.8
+ 完善文章字数统计，新增代码行数统计和时间计算
+ 修复字数统计问题
+ 新增 "站点概览额外内容" 工具栏
+ 加密文章输入密码前不获取第一张图片作为头图
+ 修复单栏下顶栏不自动折叠的问题
+ 修复 UI 瑕疵
+ 其他修复与改进

## 20211024 v1.2.7
+ 适配侧栏 Wordpress 归档日历
+ 站点概览增加作者个人介绍选项
+ 增加 AHCDN ([#284](https://github.com/solstice23/argon-theme/issues/284))
+ 增加 2 个 Filter (404 页面额外 HTML、Banner 标题 HTML)
+ 归档时间轴页面增加对应年月链接
+ 其他修复与改进

## 20211001 v1.2.6
+ 优化归档时间轴页面，支持按月分节，支持左侧栏跳转和目录
+ 适配区块左侧栏，文字头像支持全局
+ 优化全屏封面时浮动操作栏、Pjax 等体验
+ Url Hash 指向的评论突出显示
+ 优化滚动动画曲线
+ 修复 Session 初始化问题
+ 其他微调和修复

## 20210905 v1.2.5
+ 滚动条沉浸
+ Banner 显示状态新增全屏选项（Banner 可全屏作为封面）
+ 更正翻译

## 20210815 v1.2.4
+ 新增 Banner 显示状态选项（新增隐藏 Banner、迷你 Banner）
+ 新增顶栏显示状态选项 （新增顶栏不随页面滚动）
+ 新增顶栏毛玻璃选项
+ 优化单栏布局
+ 修复瀑布流图片加载后排版问题
+ 修复瀑布流布局显示错位
+ 修复头图 Lazyload 的 BUG


## 20210810 v1.2.3
+ 新增文章列表瀑布流布局
+ 修复代码不折行的 BUG
+ 博客副标题加入打字动画
+ 修复标题打字动画结束后光标瞬间闪烁问题、打字动画中止问题
+ 修复未填写邮箱时文字头像显示错误
+ 修复夜间模式下代码块显示问题
+ 修复夜间模式评论点赞后不显示

## 20210804 v1.2.2
+ 新增评论点赞功能
+ 增加一种文章列表卡片样式
+ 改进阅读进度浮动按钮显示逻辑
+ 修复 "Tab 面板" Gutenberg 组件有概率无法切换的 BUG
+ 修复夜间模式背景不切换的 BUG
+ 其他修复与改进

## 20210803 v1.2.1
+ 增加 "Tab 面板" Gutenberg 区块
+ 修复夜间模式的显示问题
+ 修复 Gutenberg 编辑器区块图标不显示的问题
+ 新增页面背景 Filter

## 20210724 v1.2.0
+ 适配 Gutenberg 编辑器，支持通过编辑器可视化插入提示、警告、折叠块、时间线、Todo List 等区块
+ 增加文章过时信息单独设置选项
+ 更改夜间模式选择文字时的背景色
+ 增加文章预览截取字数选项
+ 修复与 Gutenberg 编辑器的兼容问题
+ 其他小改动

## 20210706 v1.1.9
+ 增加一种文章列表卡片样式
+ 新增若干 Filters
+ 修复 Gutenberg 编辑器区块的显示错误问题
+ 支持 og-image Meta
+ 其他 BUG 修复

## 20210508 v1.1.8
+ 代码高亮增加更多默认选项
+ 新增若干 [Filters](https://argon-docs.solstice23.top/#/filters)
+ 修复相似文章 UI 细节问题
+ 修复说说显示错误
+ 侧栏 分类/Tag 隐藏 空分类/Tag
+ 允许隐藏顶栏标题
+ 修复访问统计问题
+ 修复与 Live2D 与 Code Syntax Block 插件的兼容问题
+ 其他 BUG 修复

## 20210219 v1.1.7
+ 修复 Mathjax v2 Pjax 加载后不渲染问题
+ 修复字数统计错误问题
+ 更改文末推荐文章列表样式
+ 分享功能支持只显示国内/国外/全部社交媒体

## 20210208 v1.1.6
+ 修复代码行数显示错误
+ 修复 RSS 问题
+ 修复 REST API 错误
+ 完善翻译
+ 修复一些显示问题
+ 更新 版本号

## 20201220 v1.1.5
+ 文章目录聚焦时会自动滚动
+ 适配 PHP 8
+ 修复评论文字头像加载错误问题
+ 修复错误

## 20201114 v1.1.4
+ 修复脚注重复的问题
+ 新增对重复脚注的处理
+ 新增代码高亮方案
+ 更新 Highlight.js 到 v10.4.0

## 20201114 v1.1.3
+ 支持脚注短代码 (ref)
+ 修复文章字数统计错误
+ 修复文章目录跳转问题
+ 修复验证码问题
+ UI 微调和其他改进

## 20201025 v1.1.2
+ 回滚 HTML Parse 代码
+ 修复 Fancybox 导致的一系列显示错误问题
+ 合并移动端割裂的 UI
+ 增加禁用 Google 字体选项
+ 修复关闭 Lazyload 时首页文章头图无法加载的问题

## 20201024 v1.1.1
+ 修复 Fancybox 可能会出现的 HTML Tag 提前闭合问题

## 20201018 v1.1.0
+ 图片缩放预览库由 Zoomify 更换为 Fancybox (仍保留 Zoomify 选项)
+ 优化评论区图片体验
+ 修复特定屏幕尺寸下侧栏边距问题
+ 其他优化

## 20201005 v1.0.4
+ 修复手机版顶栏折叠菜单图标间距问题
+ 设置页增加快速回顶和回底按钮

## 20200920 v1.0.3
+ 修复评论回复和 Pjax 冲突
+ 博主登录后自动填充加密文章密码

## 20200830 v1.0.2
+ 增加 双栏(反转) 页面布局
+ 修复和优化文章字数统计

## 20200824 v1.0.1
+ 增加 "评论文字头像" 选项（为无头像评论者生成一个纯色文字头像）
+ Github 短代码新增 Mini 尺寸

## 20200823 v1.0.0
+ 正式版

## 20200821 v0.999.beta.8
+ 优化字数统计和预计阅读时间计算方法，中英文分别统计，并排除代码块
+ 新增 "文章内标题样式" 选项
+ 修复一些代码错误
+ 评论区中表情支持放大查看
+ 夜间模式细节优化
+ 修复手机表情键盘溢出屏幕问题
+ 优化 UI 细节

## 20200819 v0.999.beta.7
+ 修复 WP Super Cache 和 Argon 不兼容的问题
+ 优化左侧栏 "功能" Tab 样式
+ 增加推荐相似文章数量选项

## 20200819 v0.999.beta.6
+ 移除 V2EX Gravatar CDN 选项
+ 增加自定义 Gravatar CDN 选项
+ 修复 Lazyload 加载不出的 BUG
+ 优化无头像的友情链接的显示
+ 修复首页说说中的视频的显示问题
+ 优化侧栏过长 Link 的显示

## 20200818 v0.999.beta.5
+ 增加 "相似文章推荐" 选项
+ 修复文章第一张图片无法作为头图的 BUG
+ 修复文章修改时间显示错误的问题
+ 优化赞赏二维码显示尺寸

## 20200817 v0.999.beta.4
+ 增加文末附加信息选项
+ 表情键盘支持长按预览表情
+ 修复 Emoji 和部分表情无法输入的问题
+ 修复回复评论时显示错误的 BUG

## 20200813 v0.999.beta.3
+ 修复较深颜色作为主题色时夜间模式下的对比度问题
+ 修复文章中 WP 引用卡片溢出问题
+ 修复小屏幕时评论区显示重叠问题

## 20200812 v0.999.beta.2
+ 评论支持发表情
+ 增加评论区表情键盘
+ 文章头图支持 Lazyload
+ 修复 Lazyload 重复加载问题
+ 修复 Wordpress 5.0 以下的兼容性问题

## 20200809 v0.999.beta.1
+ 更换 Pjax 方案为 [jquery-pjax](https://github.com/defunkt/jquery-pjax/) 魔改后的版本 [jquery-pjax-plus](https://github.com/solstice23/jquery-pjax-plus)
+ 解决 Pjax 一些兼容性问题，修复之前 Pjax 后退定位的 BUG
+ 支持滚动时自动折叠顶栏（新增该设置项）
+ 其他一些优化

## 20200807 v0.994
+ 支持将文章中第一张图片设为头图，支持每篇文章单独设置和跟随全局
+ 更改评论区 Markdown 图片解析逻辑，增强兼容性

## 20200806 v0.993
+ 增加繁体中文翻译

## 20200805 v0.992
+ Add Russian Translation (By [ostiwe](https://github.com/ostiwe))
+ 增加俄文翻译

## 20200801 v0.991
+ 修复 more 标签字数统计错误的问题
+ 完善英文翻译
+ 其他一些修改

## 20200729 v0.990
+ Add English Translation
+ 完善英文翻译

## 20200728 v0.980
+ Add English Translation (Unfinished)
+ 增加英文翻译（未完成）
+ 修复图片组第一张图片加载不出的 BUG
+ 修复折叠块中图片 Lazyload 不自动加载的 BUG
+ 其他修改

## 20200713 v0.971
+ 修 BUG

## 20200713 v0.970
+ 文章 Meta 信息支持自定义是否显示和顺序
+ 增加 fastgit 更新源
+ 修 BUG
+ 其他一堆更改记不清了

## 20200613 v0.962.1
+ 修复折叠后评论未适配夜间模式问题

## 20200601 v0.962
+ 增加过长评论自动折叠选项
+ 修改 Lazyload、Zoomify 等的初始化方式（不再以 script 标签内联在文章中）

## 20200521 v0.961
+ 新增首页隐藏特定分类文章选项
+ 新增文章 Meta 显示作者选项
+ 优化分类、标签和文章中的 SEO Keywords
+ 其他小改进

## 20200518 v0.960
+ 新增三栏布局模式

## 20200517 v0.958
+ 评论区时间显示实时更新
+ 优化评论区时间格式
+ 修复判断文章是否需要目录错误的 BUG

## 20200511 v0.957.1
+ 修 BUG

## 20200511 v0.957
+ 支持给每篇文章插入自定义 CSS
+ 修 BUG

## 20200509 v0.956.1
+ 修复首页说说图片宽度溢出的问题

## 20200509 v0.956
+ 修复首页显示的说说不显示图片的 BUG
+ 修复夜间模式切换的一个 BUG

## 20200503 v0.955
+ 404 页适配夜间模式和暗黑模式
+ 侧栏菜单适配新标签页打开选项
+ 支持可选的加密文章密码提示 (新建名为 `password_hint` 的 Meta 项)
+ 修复说说标题过长溢出问题

## 20200501 v0.954
+ 增加 "美化登录界面" 选项 (Wordpress 登录界面 Argon Design 化)
+ 修复 QQ 号获取的头像在后台显示异常问题

## 20200429 v0.953
+ 增加评论根据 QQ 号获取头像选项
+ 修复单行代码高亮的复制等问题
+ 修复代码块复制错误的 BUG
+ 调整代码块过大的边距

## 20200425 v0.951
+ 经典编辑器中增加插入代码块按钮和短代码快捷按钮
+ 优化代码高亮
+ 适配图片说明

## 20200424 v0.950
+ 内置 Highlight.js 代码高亮
	+ Mac 风格
	+ 支持行号
	+ 支持复制代码、切换行号显示、切换自动折行、全屏

## 20200418 v0.944
+ 增加默认字体选项
+ 增加默认阴影大小选项
+ 修复文章过时信息时差问题

## 20200413 v0.943.1
+ 修复 Pjax 的一个问题

## 20200412 v0.943
+ 增加归档时间轴页面模板
+ 侧栏格言支持调用一言 API
+ 增加对 Wordpress 子目录安装方式的兼容性适配选项
+ 修复和 Prism.js 的一个兼容性问题
+ 修复侧栏图标不对齐问题

## 20200411 v0.941
+ 修复评论 UA 图标错误的 BUG
+ 修复评论编辑历史记录显示错误的 BUG

## 20200409 v0.940
+ 新增评论区 UA 显示选项
+ 新增 Katex 数学解析方案

## 20200407 v0.931
+ 修复新旧版本 `Parsedown` 类库冲突的问题
+ 修复小 BUG

## 20200405 v0.930
+ 左侧栏顶部菜单支持无限层级嵌套子菜单

## 20200404 v0.925
+ Github 短代码增加可选的后端获取模式
+ 修复 "暗化" 滤镜不生效的问题

## 20200403 v0.924
+ 修复顶栏菜单 "在新标签页打开" 选项不生效的 BUG

## 20200401 v0.923
+ 修复设置顶栏图标后手机端排版的问题

## 20200331 v0.922
+ 修复评论编辑历史记录时间显示错误的问题

## 20200330 v0.921
+ 修复评论编辑历史记录的 BUG
+ 优化搜索逻辑

## 20200330 v0.920
+ 增加查看评论编辑历史记录功能
+ 增加 "谁可以查看评论编辑记录" 选项
+ 赞赏二维码弹框移到赞赏按钮上方
+ 修复分类中文章总数统计错误的 BUG

## 20200326 v0.914
+ 修复评论相关的一些小 BUG

## 20200325 v0.913
+ 夜间模式时间调整 (21:00 改为 22:00)
+ 修复小问题

## 20200324 v0.912
+ 增加 Pangu.js 文本格式化选项
+ 需要密码的文章支持 Ajax 加载

## 20200323 v0.911
+ 增加单栏模式

## 20200322 v0.910
+ 评论区支持分页
+ 新增 "无限加载" 和 "页码" 两种评论分页方式
+ 重写评论模块代码
+ 评论发送后改为局部刷新评论区
+ 优化评论/编辑体验
+ 优化其他一堆细节

## 20200321 v0.902
+ 新增新的友情链接短代码
+ 友情链接改为从 Wordpress 链接管理器中读取
+ 启用 Wordpress 链接管理器
+ 旧的友情链接短代码改名为 `sfriendlinks`
+ 评论会自动填充上一次的姓名、邮箱、网站输入框的内容
+ 增加 "评论时默认勾选 '启用邮件通知'' 复选框" 选项
+ 文章设置新增 "隐藏文章发布时间和分类" 选项
+ 更改说说文章页面 URL

⚠ 在该版本中，友情链接改为从 Wordpress 链接管理器中读取。请将友情链接迁移至 Wordpress 链接管理器中，或将原先的友链短代码改为 `sfriendlinks`。

## 20200319 v0.901
+ 评论通知邮件支持退订
+ 优化评论通知发送邮件逻辑
+ 评论 Markdown 增加对标题、有序列表和无序列表的支持
+ 手机端 UI 微调
+ 优化手机端交互体验微调
+ 修了评论的一堆 BUG

## 20200318 v0.900
+ 评论允许发送者再次编辑（可选）
+ 评论增加悄悄话模式（可选）
+ 评论增加回复时邮件通知模式（可选）
+ 优化文章访问量统计逻辑
+ 其他的一些优化和调整

## 20200315 v0.891
+ 修 BUG

## 20200315 v0.890
+ Argon 设置增加 导入/导出 功能
+ 新增日间/夜间模式不同背景选项
+ 新增 Banner 标题打字动画选项
+ 增加 jsdelivr 更新源
+ 修复一个重大 BUG

## 20200314 v0.885
+ 新增文章过时信息提示选项
+ 增加在浮动按钮栏显示跳到评论区按钮选项
+ 增加 Banner 遮罩和 Banner 标题阴影选项
+ 修复手机上的一系列小问题
+ 略微优化后台设置界面

## 20200310 v0.884
+ 增加夜间模式的另一种配色: 暗黑 (AMOLED Black)
+ 修复夜间模式相关的 BUG

## 20200309 v0.883
+ 修复过渡动画的一个问题

## 20200309 v0.882
+ 修复首页显示说说选项开启后，置顶文章不能正常显示的 BUG

## 20200309 v0.881
+ 修 BUG

## 20200309 v0.880
+ 增加夜间模式切换方案 (默认日间/默认夜间/跟随系统自动切换/根据时间自动切换)
+ 优化性能
+ 修 BUG

## 20200308 v0.873
+ 优化侧栏的搜索体验
+ 修复 Safari 上的渲染问题

## 20200306 v0.872
+ 修复 Safari 上的一系列显示问题
+ 修复点击导航栏时高度跳动的 BUG
+ 略微优化性能

## 20200306 v0.871
+ BUG 修复

## 20200306 v0.870
+ 优化顶栏搜索体验，将搜索框嵌入导航栏中，同时搜索支持 Pjax
+ 增加首页文章和说说同时显示的选项
+ 修复 Safari 上的一个性能问题
+ 增加评论禁用 Markdown 选项
+ 优化手机端阅读体验
+ 手机端浮动按钮增加透明度
+ 修复偶现的 Tooltip 乱码问题
+ 修复手机点击导航栏链接菜单不会自动关闭的问题
+ 修复其他小问题

## 20200303 v0.860
+ 编辑文章界面侧栏增加 "隐藏字数及阅读时间提示 Meta 信息" 选项
+ 优化夜间模式相关逻辑
+ 修复赞赏二维码的显示和过渡动画问题
+ 增加禁用 Pjax 选项
+ 修复 BUG

## 20200229 v0.852
+ 友情链接短代码增加随机顺序可选参数

## 20200228 v0.851
+ 修复手机端侧栏的一系列问题
+ 优化开启公告时手机端的显示效果
+ 优化手机端评论区的阅读体验
+ 增加 `noshortcode` 短代码
+ 优化浮动操作按钮菜单中恢复默认圆角大小按钮的提示

## 20200225 v0.850
+ Argon 选项中增加自定义默认卡片圆角大小设置
+ 浮动操作按钮菜单中增加了自定义圆角大小滑块
+ 优化评论区图片打开的动画曲线
+ 微调 UI 细节
+ 修复代码块和某些插件样式冲突的问题

## 20200223 v0.845
+ 修复以前手滑遗留的在新标签页打开问题

## 20200222 v0.844
+ 默认显示页脚作者信息，在 Argon 设置中增加了隐藏页脚作者信息的选项

## 20200222 v0.843
+ 修复顶栏二级菜单点击时菜单项高度跳动的 BUG
+ 细节修复
+ 删除页脚作者信息，只保留主题名称和链接

## 20200219 v0.842
+ 添加 Mathjax 2，现在有 Mathjax 3 和 2 两个版本可以选择

## 20200217 v0.841
+ 增加 "留言板" 页面模板
+ 修复浮动操作按钮与 Font Awesome 5 的类名冲突兼容问题
+ 修复夜间模式的一个小 BUG
+ 进一步完善 Pjax 逻辑

## 20200215 v0.840
+ 修复开启 "评论作者必须填入姓名和电子邮件地址" 选项后未填写名称无法发送评论的错误
+ 增加隐藏发送评论区中 "作者名称"、"邮件"、"网站" 输入框的选项
+ 增加禁用评论验证码的选项
+ 修复 Pjax 的几个 BUG
+ 完善 Pjax 逻辑，实现了近乎完美的 Pjax 体验
+ 增加 "博客 Banner 副标题" 设置选项，显示在 Banner 标题下方
+ 优化手机端有头图的博文的显示效果
+ 修复暗色滤镜与背景冲突的 BUG
+ 完善了手机端夜间模式的适配
+ 加入 "暂停更新" 选项，位于 "检测更新源" 选项中
+ 加入了 "博文发布时间"、"博文最后修改时间" 短代码
+ 一系列微调和优化

## 20200210 v0.830
+ 增加评论区 Markdown 支持
+ 优化夜间模式在页面刚载入时的体验

## 20200206 v0.820
+ 增加博客背景图片设置选项
+ 增加 沉浸式 Banner (透明) 和 毛玻璃 Banner 选项 来增强背景图片的显示效果

## 20200205 v0.810
+ BUG 修复

## 20200128 v0.800
+ 大幅提升前端加载速度
+ SEO 优化
+ 增加 SEO Description Meta 标签和 Keywords Meta 标签设置选项
+ 增强页面可访问性，优化无障碍体验
+ 修复一些问题
+ 针对打印进行优化

## 20200125 v0.703
+ Github 用户名更换适配

## 20200125 v0.702
+ 修复图片全屏预览选项关闭后无效的 BUG

## 20200123 v0.701
+ 修复不显示自定义主题色选择器时 js 的执行错误

## 20200123 v0.700
+ 增加前端自定义主题色功能（用户在浮动操作按钮博客设置菜单中可自定义主题色）
+ 问题修复

## 20200121 v0.610
+ 重构切换主题功能
+ 修复 CSS 的一堆问题
+ 修复 Pjax 带 `target="blank"` 属性的 `a` 标签在本页打开的问题
+ 一些小改进

## 20200116 v0.601
+ 进一步适配主题色 (如滚动条颜色，`a` 标签下划线颜色等)

## 20200116 v0.600
+ 增加博客主题色选项，可自定义主题色
+ 增加 SEO Meta 标签
+ 修复 Pjax 的一个 BUG

## 20200105 v0.597
+ 修复之前没发现的一个无关紧要的小问题

## 20200104
+ 更改协议为 GPL V3.0

## 20191231 v0.596
+ 修复设置界面的小问题

## 20191221 v0.595
+ 平滑滚动增加脉冲式滚动的选项 (Edge 式滚动)

## 20191216 v0.594
+ Argon 后台设置增加浮动目录
+ 增加文章目录显示序号选项
+ 修复左侧栏 Tab 的显示问题
+ 修复左侧栏浮动时在特定屏幕尺寸下的显示问题

## 20191214 v0.593
+ 博客设置增加阴影选项
+ 修复界面的一些问题
+ 修复其他的一些小问题
+ 升级 Argon 框架到 1.1.0 版本

## 20191214 v0.592
+ 加入博客设置功能
	+ 位于浮动操作按钮栏
	+ 设置选项：夜间模式、字体（衬线/无衬线）、页面滤镜
	+ 默认关闭浮动操作按钮栏的夜间模式切换按钮（与设置菜单中重复），可以在 Argon 设置中手动开启
+ 微调 CSS
+ 其他小改动

## 20191204 v0.591
+ 增加进入文章过渡动画选项（测试）

## 20191111 v0.590
+ 增加博客公告功能

## 20191107 v0.582
+ 修复未开启 Mathjax 选项时 Pjax 错误的问题

## 20191104 v0.581
+ 支持切换主题更新源
+ 修复 CSS 一个小问题

## 20191104 v0.58
+ 优化设置页面
+ 修复评论框高度错误问题

## 20191029 v0.57
+ 增加 题图(特色图片) 的支持

## 20191026 v0.56
+ 提升 Mathjax 版本到 3.0
+ 更换默认 Mathjax CDN
+ 允许自定义 Mathjax CDN
+ 修复由于 Mathjax 文件未加载成功导致 Pjax 错误的问题

## 20191023 v0.55
+ 修复手机端侧栏的小问题
+ 提升后台管理中"Argon 主题选项"菜单层级
+ 采用新的检测更新库，修复更新问题
+ 其他细节调整

## 20191017 v0.54
+ 修改手机端侧栏效果
+ 合并 CSS 文件
+ 细节微调
+ 修改加密博客阅读量统计逻辑

## 20191014 v0.53
+ 增加赞赏二维码选项
+ 增加视频短代码
+ 修改 Pjax 逻辑
+ 增加首页文章浏览不显示短代码选项
+ 修复夜间模式的一个小问题

## 20191013 v0.52
+ 增加安装统计
+ 增加时区修复

## 20191012 v0.51
+ "说说"增加点赞功能
+ 微调弹出提示的样式

## 20191010 v0.5
+ 增加 "说说" 功能
+ 增加 Github Repo 信息短代码
+ 细节修改

## 20190923 v0.4
+ 如果某个菜单没配置，会默认隐藏，不再会影响观感
+ 修复了检测更新的一个问题
+ 增加"隐藏文字"短代码，在鼠标移上时才会显示
+ 修复图片放大模糊的问题
+ Banner 支持必应每日一图
+ 适配 Android Chrome Toolbar 颜色
+ 待审核评论会打上标签提示发送者
+ 修复 Pjax 加载后评论框大小不随内容调整的 BUG
+ 夜间模式全屏放大图片图片颜色不会变暗了
+ 修复了 CSS 的一些问题
+ 修复其他一些小问题

## 20190907 v0.31
+ 修复调试时遗留下来的一个 BUG

## 20190904 v0.3
+ Pjax 加载时替换 WordPress Adminbar
+ 修复后台评论提示验证码错误问题
+ 手机减小文章页面 margin
+ Pjax 加载逻辑修改
+ 博主评论免验证码

## 20190829 v0.2
+ 修复一些 BUG
+ checkbox 增加可选的 `inline` 属性
+ 针对 Wordpress 管理条进行处理
+ 修复夜间模式的一些问题
+ 修改一些细节

# 捐赠
如果你觉得 Argon 主题不错，可以请我一杯咖啡来支持我的开发。

![微信捐赠码](https://img.solstice23.top/2020/03/07/fc4b804bf938b.png)
